'use client'

import { usePathname } from 'next/navigation'
import Link from 'next/link'
import NavigationMenu from './NavigationMenu'
import AuthGuard from './AuthGuard'
import UserMenu from './UserMenu'

export default function LayoutContent({ children }: { children: React.ReactNode }) {
  const pathname = usePathname()
  const isLoginPage = pathname === '/login'

  // Si es la página de login, no mostrar la navegación
  if (isLoginPage) {
    return (
      <div className="min-h-screen bg-gray-50">
        {children}
      </div>
    )
  }

  // Para todas las demás páginas, mostrar la navegación completa
  return (
    <>
      <nav className="bg-blue-600 text-white p-4 shadow-md">
        <div className="container mx-auto flex items-center justify-between">
          <div className="flex items-center">
            <NavigationMenu />
            <Link href="/" className="text-2xl font-bold hover:opacity-80 ml-4">
              NAVIGPS
            </Link>
          </div>
          <div className="flex items-center gap-4">
            {/* Icono de notificaciones (campana) */}
            <button
              className="p-2 rounded-md hover:bg-blue-700 transition-colors focus:outline-none focus:ring-2 focus:ring-white"
              aria-label="Notificaciones"
              title="Notificaciones"
            >
              <svg
                className="w-6 h-6"
                fill="none"
                stroke="currentColor"
                viewBox="0 0 24 24"
              >
                <path
                  strokeLinecap="round"
                  strokeLinejoin="round"
                  strokeWidth={2}
                  d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9"
                />
              </svg>
            </button>

            {/* Icono de modo claro/oscuro */}
            <button
              className="p-2 rounded-md hover:bg-blue-700 transition-colors focus:outline-none focus:ring-2 focus:ring-white"
              aria-label="Modo claro/oscuro"
              title="Cambiar tema"
            >
              <svg
                className="w-6 h-6"
                fill="none"
                stroke="currentColor"
                viewBox="0 0 24 24"
              >
                <path
                  strokeLinecap="round"
                  strokeLinejoin="round"
                  strokeWidth={2}
                  d="M20.354 15.354A9 9 0 018.646 3.646 9.003 9.003 0 0012 21a9.003 9.003 0 008.354-5.646z"
                />
              </svg>
            </button>

            {/* Menú de usuario */}
            <UserMenu />
          </div>
        </div>
      </nav>
      <main className="container mx-auto p-4 min-h-screen bg-gray-50">
        <AuthGuard>
          {children}
        </AuthGuard>
      </main>
    </>
  )
}
