import './globals.css'
import type { Metadata } from 'next'
import { Inter } from 'next/font/google'
import LayoutContent from './components/LayoutContent'

const inter = Inter({ subsets: ['latin'] })

export const metadata: Metadata = {
  title: 'NAVIGPS - Gestión de Clientes',
  description: 'Sistema de gestión de clientes NAVIGPS',
  icons: {
    icon: '/img/favicon.webp',
  },
}

export default function RootLayout({
  children,
}: {
  children: React.ReactNode
}) {
  return (
    <html lang="es">
      <body className={inter.className}>
        <LayoutContent>{children}</LayoutContent>
      </body>
    </html>
  )
}
