import Link from 'next/link'

export default function Home() {
  return (
    <div className="mt-8">
      <h1 className="text-4xl font-bold mb-8 text-center">Sistema de Gestión NAVIGPS</h1>
      <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
        <Link href="/dashboard" className="bg-white p-6 rounded-lg shadow-lg hover:shadow-xl transition transform hover:-translate-y-1">
          <div className="text-4xl mb-3">📊</div>
          <h2 className="text-2xl font-bold mb-2">Dashboard</h2>
          <p className="text-gray-600">Vista general con gráficos y métricas</p>
        </Link>
        <Link href="/clientes" className="bg-white p-6 rounded-lg shadow-lg hover:shadow-xl transition transform hover:-translate-y-1">
          <div className="text-4xl mb-3">👥</div>
          <h2 className="text-2xl font-bold mb-2">Clientes</h2>
          <p className="text-gray-600">Gestiona todos tus clientes</p>
        </Link>
        <Link href="/productos" className="bg-white p-6 rounded-lg shadow-lg hover:shadow-xl transition transform hover:-translate-y-1">
          <div className="text-4xl mb-3">📦</div>
          <h2 className="text-2xl font-bold mb-2">Productos</h2>
          <p className="text-gray-600">Gestiona tus productos y servicios</p>
        </Link>
        <Link href="/suscripciones" className="bg-white p-6 rounded-lg shadow-lg hover:shadow-xl transition transform hover:-translate-y-1">
          <div className="text-4xl mb-3">📅</div>
          <h2 className="text-2xl font-bold mb-2">Suscripciones</h2>
          <p className="text-gray-600">Mensuales y anuales</p>
        </Link>
        <Link href="/pagos" className="bg-white p-6 rounded-lg shadow-lg hover:shadow-xl transition transform hover:-translate-y-1">
          <div className="text-4xl mb-3">💰</div>
          <h2 className="text-2xl font-bold mb-2">Pagos</h2>
          <p className="text-gray-600">Control de pagos y cuentas por cobrar</p>
        </Link>
        <Link href="/cotizaciones" className="bg-white p-6 rounded-lg shadow-lg hover:shadow-xl transition transform hover:-translate-y-1">
          <div className="text-4xl mb-3">📄</div>
          <h2 className="text-2xl font-bold mb-2">Cotizaciones</h2>
          <p className="text-gray-600">Gestiona tus cotizaciones</p>
        </Link>
        <Link href="/contratos" className="bg-white p-6 rounded-lg shadow-lg hover:shadow-xl transition transform hover:-translate-y-1">
          <div className="text-4xl mb-3">📋</div>
          <h2 className="text-2xl font-bold mb-2">Contratos</h2>
          <p className="text-gray-600">Administra contratos</p>
        </Link>
        <Link href="/recordatorios" className="bg-white p-6 rounded-lg shadow-lg hover:shadow-xl transition transform hover:-translate-y-1">
          <div className="text-4xl mb-3">🔔</div>
          <h2 className="text-2xl font-bold mb-2">Recordatorios</h2>
          <p className="text-gray-600">No olvides nada importante</p>
        </Link>
        <Link href="/formularios" className="bg-white p-6 rounded-lg shadow-lg hover:shadow-xl transition transform hover:-translate-y-1">
          <div className="text-4xl mb-3">📝</div>
          <h2 className="text-2xl font-bold mb-2">Formularios</h2>
          <p className="text-gray-600">Crea formularios y compártelos con tus clientes</p>
        </Link>
      </div>
    </div>
  )
}
