export interface Cliente {
  id: string
  nombre?: string
  email?: string
  telefono?: string
  empresa?: string
  direccion?: string
  rfc?: string
  notas?: string
  activo: boolean
  created_at: string
  updated_at: string
}

export interface Suscripcion {
  id: string
  cliente_id: string
  tipo: 'mensual' | 'anual'
  precio: number
  fecha_inicio: string
  fecha_fin?: string
  patente?: string
  producto_id?: string
  cantidad?: number
  incluir_iva?: boolean
  estado: 'activa' | 'vencida' | 'cancelada'
  created_at: string
  updated_at: string
}

export interface Pago {
  id: string
  cliente_id: string
  suscripcion_id?: string
  producto_id?: string
  monto: number
  fecha_pago: string
  fecha_inicio?: string
  fecha_fin?: string
  metodo_pago?: string
  referencia?: string
  estado: 'pendiente' | 'completado' | 'cancelado'
  incluir_iva?: boolean
  notas?: string
  created_at: string
}

export interface Usuario {
  id: string
  email: string
  nombre?: string
  rol: 'admin' | 'cliente'
  cliente_id?: string
  activo: boolean
  created_at: string
  updated_at: string
}

export interface CuentaPorCobrar {
  id: string
  cliente_id: string
  monto: number
  fecha_vencimiento: string
  descripcion?: string
  estado: 'pendiente' | 'pagada' | 'vencida'
  created_at: string
}

export interface Producto {
  id: string
  nombre: string
  descripcion?: string
  precio: number
  activo: boolean
  created_at: string
  updated_at: string
}

export interface CotizacionItem {
  id: string
  cotizacion_id: string
  producto_id?: string
  cantidad: number
  precio_unitario: number
  descripcion?: string
  subtotal: number
  incluir_iva?: boolean
  iva?: number
  orden: number
  created_at: string
}

export interface Cotizacion {
  id: string
  cliente_id: string
  numero_cotizacion: string
  descripcion?: string
  monto: number
  subtotal?: number
  iva?: number
  incluir_iva?: boolean
  fecha_emision: string
  fecha_vencimiento?: string
  estado: 'pendiente' | 'aceptada' | 'rechazada' | 'vencida'
  created_at: string
  updated_at: string
}

export interface Contrato {
  id: string
  cliente_id: string
  numero_contrato: string
  tipo_servicio: string
  fecha_inicio: string
  fecha_fin?: string
  monto: number
  estado: 'activo' | 'vencido' | 'cancelado'
  archivo_url?: string
  created_at: string
  updated_at: string
}

export interface Recordatorio {
  id: string
  cliente_id: string
  titulo: string
  descripcion?: string
  fecha_recordatorio: string
  tipo?: string
  completado: boolean
  created_at: string
}

export type CampoFormularioTipo = 'text' | 'email' | 'tel' | 'date' | 'textarea' | 'select' | 'number' | 'checkbox'

export interface CampoFormulario {
  id: string
  nombre: string
  etiqueta: string
  tipo: CampoFormularioTipo
  requerido: boolean
  placeholder?: string
  opciones?: string[] // Para select
  orden: number
}

export interface Formulario {
  id: string
  titulo: string
  descripcion?: string
  campos: CampoFormulario[]
  activo: boolean
  link_publico: string
  created_at: string
  updated_at: string
}

export interface RespuestaFormulario {
  id: string
  formulario_id: string
  datos: Record<string, any> // JSON con las respuestas
  fecha_visita?: string
  ip_address?: string
  created_at: string
}
